//@author: dottore
//@help: this shader evaluate the mean luminance value of the incoming 16x16 pixels texture
//@tags: mean
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tWVP: WORLDVIEWPROJECTION;

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

texture TexPrevLum <string uiname="Texture Previous Lum";>;
sampler SampPrevLum = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexPrevLum);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

float vel <string uiname="Adaptive velocity";> =1;
float KeyA = 0.18;
float blend;
float fixed;
float MaxLumValue;

#define Xres 16
#define Yres 16
#define SqrRes (Xres*Yres)


//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
vs2ps VS(
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //declare output struct
    vs2ps Out;

    //transform position
    Out.Pos = mul(PosO, tWVP);
    
    //transform texturecoordinates
    Out.TexCd = TexCd;

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------
float4 PS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float totalLum =0;
    
    float prevLum = tex2D( SampPrevLum, float2(0,0)).r;

    int i, j;
    float offSizeX = 1 / (float)Xres;
    float offSizeY = 1 / (float)Yres;
    
    for (i = 0; i< Xres; i += 1)
        {
          for (j = 0; j< Yres; j += 1)
              {
              float2 offset = float2(i*offSizeX, j*offSizeY);
              float sample = tex2D( Samp, offset).r;
              totalLum += sample;
              }
        }
     totalLum /=SqrRes;
    return max(prevLum + (vel*(KeyA/lerp(min(totalLum,MaxLumValue),fixed,blend) - prevLum)),0.0001);

}



// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}
